<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Listing extends Model 
{

    protected $table = 'listing';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function user()
    {
        return $this->belongsTo('App\User');
    }

    public function reservations()
    {
        return $this->hasMany('App\Reservation');
    }

    public function reviews()
    {
        return $this->hasMany('App\Review');
    }

    public function photos()
    {
        return $this->hasMany('App\Photo');
    }

    public function policy()
    {
        return $this->hasOne('App\Policy');
    }

    public function amenities()
    {
        return $this->hasMany('App\Amenity');
    }

}