<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateListingTable extends Migration {

	public function up()
	{
		Schema::create('listing', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->unsigned();
			$table->boolean('featured')->default(FALSE);
			$table->string('title');
			$table->longText('content');
			$table->string('owner_name');
			$table->string('owner_email');
			$table->string('long');
			$table->boolean('published')->default(FALSE);
			$table->boolean('approved')->default(FALSE);
			$table->string('lat');
			$table->string('type');
			$table->integer('rooms');
			$table->integer('bathrooms');
			$table->integer('capacity');
			$table->text('cover_photo');
			$table->integer('min_hours');
			$table->string('price');
			$table->datetime('created_at');
			$table->datetime('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('listing');
	}
}