<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('first_name');
			$table->string('last_name');
			$table->integer('age');
			$table->string('sex');
			$table->string('address_line_1');
			$table->string('address_line_2')->nullable();
			$table->string('address_line_3')->nullable();
			$table->string('address_line_4')->nullable();
			$table->string('postcode');
			$table->string('town');
			$table->string('card_account_number')->nullable();
			$table->string('card_sort_code')->nullable();
			$table->string('email');
			$table->string('phone_number');
			$table->string('type');
			$table->string('firm_id');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}