<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Store extends Model 
{

    protected $table = 'stores';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function account()
    {
        return $this->belongsTo('Account', 'account_id');
    }

    public function products()
    {
        return $this->belongsToMany('Product');
    }

}