<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('words', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lessons', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('activities', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lesson_words', function(Blueprint $table) {
			$table->foreign('lession_id')->references('id')->on('lessons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lesson_words', function(Blueprint $table) {
			$table->foreign('word_id')->references('id')->on('words')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('word_answers', function(Blueprint $table) {
			$table->foreign('word_id')->references('id')->on('words')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lesson_results', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lesson_results', function(Blueprint $table) {
			$table->foreign('lession_id')->references('id')->on('lessons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_relationships', function(Blueprint $table) {
			$table->foreign('following_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user_relationships', function(Blueprint $table) {
			$table->foreign('follower_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('learned_words', function(Blueprint $table) {
			$table->foreign('word_id')->references('id')->on('words')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('learned_words', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('words', function(Blueprint $table) {
			$table->dropForeign('words_category_id_foreign');
		});
		Schema::table('lessons', function(Blueprint $table) {
			$table->dropForeign('lessons_category_id_foreign');
		});
		Schema::table('activities', function(Blueprint $table) {
			$table->dropForeign('activities_user_id_foreign');
		});
		Schema::table('lesson_words', function(Blueprint $table) {
			$table->dropForeign('lesson_words_lession_id_foreign');
		});
		Schema::table('lesson_words', function(Blueprint $table) {
			$table->dropForeign('lesson_words_word_id_foreign');
		});
		Schema::table('word_answers', function(Blueprint $table) {
			$table->dropForeign('word_answers_word_id_foreign');
		});
		Schema::table('lesson_results', function(Blueprint $table) {
			$table->dropForeign('lesson_results_user_id_foreign');
		});
		Schema::table('lesson_results', function(Blueprint $table) {
			$table->dropForeign('lesson_results_lession_id_foreign');
		});
		Schema::table('user_relationships', function(Blueprint $table) {
			$table->dropForeign('user_relationships_following_id_foreign');
		});
		Schema::table('user_relationships', function(Blueprint $table) {
			$table->dropForeign('user_relationships_follower_id_foreign');
		});
		Schema::table('learned_words', function(Blueprint $table) {
			$table->dropForeign('learned_words_word_id_foreign');
		});
		Schema::table('learned_words', function(Blueprint $table) {
			$table->dropForeign('learned_words_user_id_foreign');
		});
	}
}