<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateParticipantTable extends Migration {

	public function up()
	{
		Schema::create('participant', function(Blueprint $table) {
			$table->increments('id');
			$table->tinyInteger('gender')->nullable();
			$table->string('firstname', 80)->nullable();
			$table->string('lastname', 80)->nullable();
			$table->string('email', 180)->nullable();
			$table->smallInteger('company_id')->nullable();
			$table->string('job_position', 150)->nullable();
			$table->json('custom_fields')->nullable();
			$table->mediumInteger('comm_id')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('participant');
	}
}