<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAnketaTable extends Migration {

	public function up()
	{
		Schema::create('Anketa', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->string('familia', 255);
			$table->string('imya', 128);
			$table->string('otchestvo', 128);
			$table->date('brithday');
			$table->string('phone_city');
			$table->string('phone_mob');
			$table->string('sniils', 14);
			$table->timestamps();
			$table->string('photo');
			$table->string('barcode');
			$table->string('note');
			$table->integer('prichinas_id');
			$table->string('prichinas_note', 255);
			$table->date('pricinas_date_ot');
			$table->boolean('prichinas_stop');
			$table->timestamps();
			$table->softDeletes();
			$table->date('pricinas_date_do');
			$table->integer('semeyka_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('Anketa');
	}
}