<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDriverTable extends Migration {

	public function up()
	{
		Schema::create('driver', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->nullable();
			$table->integer('branch_id')->nullable();
			$table->string('name')->nullable();
			$table->enum('status', array('active', 'inactive'))->nullable();
			$table->boolean('busy')->nullable()->default(0);
		});
	}

	public function down()
	{
		Schema::drop('driver');
	}
}