<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOutcomesTable extends Migration {

	public function up()
	{
		Schema::create('outcomes', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('value');
			$table->string('description');
			$table->string('name');
			$table->date('date');
			$table->enum('status', array('paid', 'not_paid'));
			$table->enum('payment_method', array('cash', 'cheques', 'voucher', 'bank_transfer'));
			$table->integer('bank_id');
			$table->integer('currency_id');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('outcomes');
	}
}