<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientsTable extends Migration {

	public function up()
	{
		Schema::create('clients', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->timestamps();
			$table->string('phone');
			$table->string('email');
			$table->integer('blood_type_id')->unsigned();
			$table->date('d_o_b');
			$table->date('last_donation_date');
			$table->integer('city_id')->unsigned();
			$table->integer('pin_code')->unsigned();
			$table->string('api_toke', 60);
			$table->string('password');
			$table->enum('blood_types', array(''));
		});
	}

	public function down()
	{
		Schema::drop('clients');
	}
}