<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMediasTable extends Migration {

	public function up()
	{
		Schema::create('medias', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('cat_id')->unsigned()->nullable();
			$table->enum('type', array('trailer', 'clip', 'photo', 'promo'));
			$table->string('name');
			$table->string('slug');
			$table->text('description');
			$table->string('url', 1024);
			$table->string('country');
			$table->string('city');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('medias');
	}
}