<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class JobApplication extends Model 
{

    protected $table = 'job_applications';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function users()
    {
        return $this->belongsTo('App\User');
    }

    public function jobOffer()
    {
        return $this->hasOne('App\JobOffer');
    }

}