<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class JobApplication extends Eloquent {

	protected $table = 'job_applications';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function users()
	{
		return $this->belongsTo('App\User');
	}

	public function jobOffer()
	{
		return $this->hasOne('App\JobOffer');
	}

}