<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTranslationsTable extends Migration {

	public function up()
	{
		Schema::create('translations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('lang_from', 50);
			$table->text('seg_from');
			$table->string('lang_to', 50);
			$table->text('seg_to');
			$table->integer('file_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('translations');
	}
}