<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomMessagesTable extends Migration {

	public function up()
	{
		Schema::create('custom_messages', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('tenant_id')->unsigned();
			$table->enum('type', array('scene1', 'scene2', 'scene3'));
			$table->text('email_message')->nullable();
			$table->text('landing_page_message')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('custom_messages');
	}
}