<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTenantsTable extends Migration {

	public function up()
	{
		Schema::create('tenants', function(Blueprint $table) {
			$table->increments('id', true);
			$table->string('email', 255);
			$table->string('domain', 50);
			$table->string('logo')->nullable();
			$table->integer('expiry_counter');
			$table->string('theme_background')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('tenants');
	}
}