<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('categories', function(Blueprint $table) {
			$table->bigIncrements('id', true)->primary();
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 191);
			$table->string('image', 191)->nullable();
			$table->bigInteger('parent_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('categories');
	}
}