<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->bigIncrements('id', true)->primary();
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 191);
			$table->string('image', 191);
			$table->bigInteger('category_id')->unsigned();
			$table->float('price');
			$table->float('discount_price')->default('0');
			$table->text('description');
			$table->bigInteger('provider_id')->unsigned();
			$table->integer('quantity')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}