<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWithdrawsTable extends Migration {

	public function up()
	{
		Schema::create('withdraws', function(Blueprint $table) {
			$table->timestamps();
			$table->softDeletes();
			$table->bigIncrements('id', true)->primary();
			$table->bigInteger('provider_id')->unsigned();
			$table->double('amount');
			$table->enum('withdraw_type', array('stc', 'bank'));
			$table->enum('status', array('waiting', 'approved', 'refused'));
			$table->timestamp('settlement_at')->nullable();
			$table->string('settlement_by')->nullable();
			$table->string('settlement_image')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('withdraws');
	}
}