<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAddressesTable extends Migration {

	public function up()
	{
		Schema::create('addresses', function(Blueprint $table) {
			$table->bigIncrements('id', true)->primary();
			$table->timestamps();
			$table->softDeletes();
			$table->decimal('lat', 10,8);
			$table->decimal('lng', 10,8);
			$table->string('city', 191);
			$table->text('map_desc');
			$table->bigInteger('user_id')->unsigned()->index();
		});
	}

	public function down()
	{
		Schema::drop('addresses');
	}
}