<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('nume');
			$table->string('prenume');
			$table->string('email');
			$table->text('password');
			$table->bigInteger('telefon');
			$table->tinyInteger('active');
			$table->text('informatii');
			$table->enum('user_type', array('4', '1', '2', '3'));
			$table->enum('client_type', array('1', '2', '3'))->nullable();
			$table->text('rememberToken');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}