<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function locatiiConsum()
	{
		return $this->hasMany('LocatieConsum');
	}

	public function oferta()
	{
		return $this->hasOne('Oferta');
	}

	public function tickete()
	{
		return $this->hasMany('Tichet');
	}

}