<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTichetsTable extends Migration {

	public function up()
	{
		Schema::create('tichets', function(Blueprint $table) {
			$table->increments('id');
			$table->string('titlu');
			$table->string('telefon', 100);
			$table->string('email', 100);
			$table->enum('sursa_tichet', array('1', '2', '3', '4'));
			$table->enum('prioritate', array('5', '4', '3', '2', '1'));
			$table->smallInteger('categorie');
			$table->text('nota');
			$table->timestamps();
			$table->integer('user_id')->unsigned()->nullable();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('tichets');
	}
}