<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLocatieConsumTable extends Migration {

	public function up()
	{
		Schema::create('locatie_consum', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned()->nullable();
			$table->string('judet', 100);
			$table->string('furnizor_actual', 255);
			$table->string('nivel_tensiune', 150);
			$table->text('adresa_locatie');
			$table->string('categorie_consum', 50);
			$table->string('istoric_consum', 255);
			$table->tinyInteger('active');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('locatie_consum');
	}
}