<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTeamsTable extends Migration {

	public function up()
	{
		Schema::create('teams', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('image');
			$table->integer('country_id');
			$table->integer('city_id');
			$table->integer('coach_id')->unsigned();
			$table->string('stadium');
			$table->integer('goals_scored');
			$table->integer('goals_conceded');
			$table->integer('league_position');
			$table->integer('points');
			$table->integer('wins');
			$table->integer('draws');
			$table->date('foundes');
			$table->integer('losses');
			$table->string('players');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('teams');
	}
}