<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMediasTable extends Migration {

	public function up()
	{
		Schema::create('medias', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('url_type', array('link', 'file'));
			$table->enum('file_type', array('video', 'image'));
			$table->text('url');
			$table->integer('team_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
			$table->integer('match_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('medias');
	}
}