<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTeamMembersTable extends Migration {

	public function up()
	{
		Schema::create('team_members', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->integer('team_id')->unsigned();
			$table->enum('type', array('goal_keeper', 'defender', 'winger', 'midfielder', 'striker', 'utility', 'technical_staff'));
			$table->integer('matches_number');
			$table->integer('player_number');
			$table->text('Biography');
			$table->string('height');
			$table->string('weight');
			$table->integer('assists_number');
			$table->integer('goals_scored');
			$table->integer('wins');
			$table->integer('draws');
			$table->integer('total_passes');
			$table->string('successful_passes');
			$table->integer('passes_in_ninety_minutes');
			$table->string('total_shots');
			$table->integer('shots_on_target');
			$table->integer('offside_cases');
			$table->integer('errors');
			$table->integer('yellow_card')->default('0');
			$table->integer('red_card')->default('0');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('team_members');
	}
}