<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMatchesTable extends Migration {

	public function up()
	{
		Schema::create('matches', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('match_type_id')->unsigned();
			$table->integer('first_team_id')->unsigned();
			$table->integer('second_team_id')->unsigned();
			$table->enum('half', array('1', '2'));
			$table->datetime('date');
			$table->integer('group_id')->unsigned();
			$table->enum('home_and_away', array('home', 'away'));
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('matches');
	}
}