<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserAddressTable extends Migration {

	public function up()
	{
		Schema::create('user_address', function(Blueprint $table) {
			$table->increments('id');
			$table->bigIncrements('user_id');
			$table->string('address')->nullable();
			$table->string('country')->nullable();
			$table->string('city')->nullable();
			$table->string('neighborhood')->nullable();
			$table->string('street')->nullable();
			$table->string('house_description')->nullable();
			$table->smallInteger('postal_code');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('user_address');
	}
}