<?php

namespace App\Models;

class User extends Eloquent {

	protected $table = 'user';
	public $timestamps = true;

	public function address()
	{
		return $this->hasMany('Address');
	}

	public function reviews()
	{
		return $this->hasMany('Review');
	}

	public function cart()
	{
		return $this->hasOne('Cart');
	}

	public function favouriteProducts()
	{
		return $this->belongsToMany('Product', 'favourites');
	}

	public function notifications()
	{
		return $this->hasMany('Notification');
	}

}