<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateParagraphsTable extends Migration {

	public function up()
	{
		Schema::create('paragraphs', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title');
			$table->text('description');
			$table->integer('section_id')->unsigned();
			$table->integer('language_id')->unsigned();
			$table->integer('display_order')->unsigned();
			$table->boolean('required');
			$table->boolean('default');
			$table->integer('contract_type_id')->unsigned()->nullable();
			$table->decimal('price')->nullable();
			$table->integer('paragraph_type_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('paragraphs');
	}
}