<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Contract extends Eloquent {

	protected $table = 'contracts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function contractType()
	{
		return $this->hasOne('App\Models\ContractType');
	}

	public function buildingType()
	{
		return $this->hasOne('App\Models\BuildingType');
	}

	public function language()
	{
		return $this->hasOne('App\Models\Languages');
	}

}