<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Paragraph extends Eloquent {

	protected $table = 'paragraphs';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function language()
	{
		return $this->hasOne('App\Models\Languages');
	}

	public function section()
	{
		return $this->hasOne('App\Models\Section');
	}

	public function paragraphType()
	{
		return $this->hasOne('App\Models\ParagraphType');
	}

}