<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContractsTable extends Migration {

	public function up()
	{
		Schema::create('contracts', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('contract_type_id')->unsigned();
			$table->integer('building_type_id')->unsigned();
			$table->integer('language_id')->unsigned();
			$table->datetime('expire');
			$table->integer('user_id')->unsigned();
			$table->integer('tenant_id')->unsigned();
			$table->integer('landlord_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('contracts');
	}
}