<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('comments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('paragraph_id')->references('id')->on('paragraphs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('contract_id')->references('id')->on('contracts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('paragraphs', function(Blueprint $table) {
			$table->foreign('section_id')->references('id')->on('sections')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('paragraphs', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('languages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('paragraphs', function(Blueprint $table) {
			$table->foreign('contract_type_id')->references('id')->on('contract_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('paragraphs', function(Blueprint $table) {
			$table->foreign('paragraph_type_id')->references('id')->on('paragraph_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('contracts', function(Blueprint $table) {
			$table->foreign('contract_type_id')->references('id')->on('contract_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('contracts', function(Blueprint $table) {
			$table->foreign('building_type_id')->references('id')->on('building_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('contracts', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('languages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('contracts', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('contracts', function(Blueprint $table) {
			$table->foreign('tenant_id')->references('id')->on('persons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('contracts', function(Blueprint $table) {
			$table->foreign('landlord_id')->references('id')->on('persons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('contract_content', function(Blueprint $table) {
			$table->foreign('contract_id')->references('id')->on('contracts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('contract_content', function(Blueprint $table) {
			$table->foreign('paragraph_id')->references('id')->on('paragraphs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('repairings', function(Blueprint $table) {
			$table->foreign('person_id')->references('id')->on('persons')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('repairing_content', function(Blueprint $table) {
			$table->foreign('repairing_id')->references('id')->on('repairings')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('repairing_content', function(Blueprint $table) {
			$table->foreign('paragraph_id')->references('id')->on('paragraphs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_role_id_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_parent_id_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_paragraph_id_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_user_id_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_contract_id_foreign');
		});
		Schema::table('paragraphs', function(Blueprint $table) {
			$table->dropForeign('paragraphs_section_id_foreign');
		});
		Schema::table('paragraphs', function(Blueprint $table) {
			$table->dropForeign('paragraphs_language_id_foreign');
		});
		Schema::table('paragraphs', function(Blueprint $table) {
			$table->dropForeign('paragraphs_contract_type_id_foreign');
		});
		Schema::table('paragraphs', function(Blueprint $table) {
			$table->dropForeign('paragraphs_paragraph_type_id_foreign');
		});
		Schema::table('contracts', function(Blueprint $table) {
			$table->dropForeign('contracts_contract_type_id_foreign');
		});
		Schema::table('contracts', function(Blueprint $table) {
			$table->dropForeign('contracts_building_type_id_foreign');
		});
		Schema::table('contracts', function(Blueprint $table) {
			$table->dropForeign('contracts_language_id_foreign');
		});
		Schema::table('contracts', function(Blueprint $table) {
			$table->dropForeign('contracts_user_id_foreign');
		});
		Schema::table('contracts', function(Blueprint $table) {
			$table->dropForeign('contracts_tenant_id_foreign');
		});
		Schema::table('contracts', function(Blueprint $table) {
			$table->dropForeign('contracts_landlord_id_foreign');
		});
		Schema::table('contract_content', function(Blueprint $table) {
			$table->dropForeign('contract_content_contract_id_foreign');
		});
		Schema::table('contract_content', function(Blueprint $table) {
			$table->dropForeign('contract_content_paragraph_id_foreign');
		});
		Schema::table('repairings', function(Blueprint $table) {
			$table->dropForeign('repairings_person_id_foreign');
		});
		Schema::table('repairing_content', function(Blueprint $table) {
			$table->dropForeign('repairing_content_repairing_id_foreign');
		});
		Schema::table('repairing_content', function(Blueprint $table) {
			$table->dropForeign('repairing_content_paragraph_id_foreign');
		});
	}
}