<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Comment extends Eloquent {

	protected $table = 'comments';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function paragraph()
	{
		return $this->hasOne('App\Models\Paragraph');
	}

	public function user()
	{
		return $this->hasOne('App\Models\User');
	}

	public function contract()
	{
		return $this->hasOne('App\Models\Contract');
	}

}