<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMaterialsTable extends Migration {

	public function up()
	{
		Schema::create('materials', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('category_id')->unsigned();
			$table->string('title', 255)->nullable();
			$table->integer('author_id')->unsigned();
			$table->string('image');
			$table->string('background_color', 255);
			$table->string('sound_track', 255);
			$table->string('minutes', 255);
			$table->text('description')->nullable();
			$table->string('listen_count', 255);
			$table->boolean('is_paid')->default(0,1);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('materials');
	}
}