<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('brands', function(Blueprint $table) {
			$table->foreign('submitted_by_user_id')->references('submitted_by_user_id')->on('brands')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('brand_id')->references('brand_id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('submitted_by_user_id')->references('submitted_by_user_id')->on('products')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->foreign('user_id')->references('user_id')->on('reviews')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->foreign('product_id')->references('product_id')->on('reviews')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('keyword_product', function(Blueprint $table) {
			$table->foreign('keyword_id')->references('keyword_id')->on('keyword_product')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('keyword_product', function(Blueprint $table) {
			$table->foreign('product_id')->references('product_id')->on('keyword_product')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('brand_keyword', function(Blueprint $table) {
			$table->foreign('keyword_id')->references('keyword_id')->on('brand_keyword')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('brand_keyword', function(Blueprint $table) {
			$table->foreign('brand_id')->references('brand_id')->on('brand_keyword')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->foreign('notification_rule_id')->references('notification_rule_id')->on('notifications')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('notification_rules', function(Blueprint $table) {
			$table->foreign('user_id')->references('user_id')->on('notification_rules')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('threads', function(Blueprint $table) {
			$table->foreign('source_id')->references('source_id')->on('threads')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('tweets', function(Blueprint $table) {
			$table->foreign('thread_id')->references('thread_id')->on('tweets')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('searchs', function(Blueprint $table) {
			$table->foreign('keyword_id')->references('keyword_id')->on('searchs')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('searchs', function(Blueprint $table) {
			$table->foreign('ip_address_id')->references('ip_address_id')->on('searchs')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('pageviews', function(Blueprint $table) {
			$table->foreign('ip_address_id')->references('ip_address_id')->on('pageviews')
						->onDelete('cascade')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('brands', function(Blueprint $table) {
			$table->dropForeign('brands_submitted_by_user_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_brand_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_submitted_by_user_id_foreign');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->dropForeign('reviews_user_id_foreign');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->dropForeign('reviews_product_id_foreign');
		});
		Schema::table('keyword_product', function(Blueprint $table) {
			$table->dropForeign('keyword_product_keyword_id_foreign');
		});
		Schema::table('keyword_product', function(Blueprint $table) {
			$table->dropForeign('keyword_product_product_id_foreign');
		});
		Schema::table('brand_keyword', function(Blueprint $table) {
			$table->dropForeign('brand_keyword_keyword_id_foreign');
		});
		Schema::table('brand_keyword', function(Blueprint $table) {
			$table->dropForeign('brand_keyword_brand_id_foreign');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->dropForeign('notifications_notification_rule_id_foreign');
		});
		Schema::table('notification_rules', function(Blueprint $table) {
			$table->dropForeign('notification_rules_user_id_foreign');
		});
		Schema::table('threads', function(Blueprint $table) {
			$table->dropForeign('threads_source_id_foreign');
		});
		Schema::table('tweets', function(Blueprint $table) {
			$table->dropForeign('tweets_thread_id_foreign');
		});
		Schema::table('searchs', function(Blueprint $table) {
			$table->dropForeign('searchs_keyword_id_foreign');
		});
		Schema::table('searchs', function(Blueprint $table) {
			$table->dropForeign('searchs_ip_address_id_foreign');
		});
		Schema::table('pageviews', function(Blueprint $table) {
			$table->dropForeign('pageviews_ip_address_id_foreign');
		});
	}
}