<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('beacon', function(Blueprint $table) {
			$table->foreign('restaurant_id')->references('id')->on('restaurante')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('platillo', function(Blueprint $table) {
			$table->foreign('restaurant_id')->references('id')->on('restaurante')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('fotos', function(Blueprint $table) {
			$table->foreign('platillo_id')->references('id')->on('platillo')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('compras', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('compras', function(Blueprint $table) {
			$table->foreign('restaurant_id')->references('id')->on('restaurante')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('movimientoPlatillos', function(Blueprint $table) {
			$table->foreign('compra_id')->references('id')->on('compras')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('movimientoPlatillos', function(Blueprint $table) {
			$table->foreign('platillo_id')->references('id')->on('platillo')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('beacon', function(Blueprint $table) {
			$table->dropForeign('beacon_restaurant_id_foreign');
		});
		Schema::table('platillo', function(Blueprint $table) {
			$table->dropForeign('platillo_restaurant_id_foreign');
		});
		Schema::table('fotos', function(Blueprint $table) {
			$table->dropForeign('fotos_platillo_id_foreign');
		});
		Schema::table('compras', function(Blueprint $table) {
			$table->dropForeign('compras_user_id_foreign');
		});
		Schema::table('compras', function(Blueprint $table) {
			$table->dropForeign('compras_restaurant_id_foreign');
		});
		Schema::table('movimientoPlatillos', function(Blueprint $table) {
			$table->dropForeign('movimientoPlatillos_compra_id_foreign');
		});
		Schema::table('movimientoPlatillos', function(Blueprint $table) {
			$table->dropForeign('movimientoPlatillos_platillo_id_foreign');
		});
	}
}