<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRestaurantsTable extends Migration {

	public function up()
	{
		Schema::create('restaurants', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 255);
			$table->string('email', 255);
			$table->string('password', 100);
			$table->integer('mobile')->nullable();
			$table->integer('whatsApp')->nullable();
			$table->tinyInteger('status')->default('1');
			$table->decimal('minimum_charge', 255);
			$table->decimal('delivery_cost');
			$table->integer('region_id')->unsigned()->nullable();
			$table->string('image', 255);
		});
	}

	public function down()
	{
		Schema::drop('restaurants');
	}
}