<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned()->nullable();
			$table->integer('restaurant_id');
			$table->string('address', 255);
			$table->enum('state', array('pending', 'accepted', 'rejected', 'delivered', 'declined'));
			$table->string('order_number', 100)->nullable();
			$table->enum('payment_method', array('cashondelivery', 'online'));
			$table->text('notes')->nullable();
			$table->decimal('commission');
			$table->decimal('order_cost');
			$table->decimal('delivery_cost');
			$table->decimal('total')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}