<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('username', 255);
			$table->string('email', 255);
			$table->string('name', 255);
			$table->string('position', 255);
			$table->string('nama_unit', 255);
			$table->datetime('last_logged_in')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}