<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateToursTable extends Migration {

	public function up()
	{
		Schema::create('tours', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->text('overview')->nullable();
			$table->longText('description')->nullable();
			$table->longText('Included');
			$table->longText('Excluded');
			$table->longText('notes');
			$table->string('Type');
			$table->string('Run');
			$table->integer('Duration');
			$table->longText('Facilities')->nullable();
			$table->text('Destinations');
			$table->integer('start_price');
			$table->integer('discount')->nullable();
			$table->longText('prices');
			$table->string('title');
			$table->string('slug');
		});
	}

	public function down()
	{
		Schema::drop('tours');
	}
}