<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('iteneraries', function(Blueprint $table) {
			$table->foreign('tour_id')->references('id')->on('tours')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('itenerary_days', function(Blueprint $table) {
			$table->foreign('itenerary_id')->references('id')->on('iteneraries')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('prices', function(Blueprint $table) {
			$table->foreign('tour_id')->references('id')->on('tours')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->foreign('tour_id')->references('id')->on('tours')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->foreign('destination_id')->references('id')->on('destinations')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->foreign('post_id')->references('id')->on('posts')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('snippets', function(Blueprint $table) {
			$table->foreign('description_id')->references('id')->on('destinations')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('faq', function(Blueprint $table) {
			$table->foreign('description_id')->references('id')->on('destinations')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('partners', function(Blueprint $table) {
			$table->foreign('description_id')->references('id')->on('destinations')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('inqueries', function(Blueprint $table) {
			$table->foreign('tour_id')->references('id')->on('tours')
						->onDelete('set null')
						->onUpdate('set null');
		});
	}

	public function down()
	{
		Schema::table('iteneraries', function(Blueprint $table) {
			$table->dropForeign('iteneraries_tour_id_foreign');
		});
		Schema::table('itenerary_days', function(Blueprint $table) {
			$table->dropForeign('itenerary_days_itenerary_id_foreign');
		});
		Schema::table('prices', function(Blueprint $table) {
			$table->dropForeign('prices_tour_id_foreign');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->dropForeign('reviews_tour_id_foreign');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->dropForeign('reviews_destination_id_foreign');
		});
		Schema::table('comments', function(Blueprint $table) {
			$table->dropForeign('comments_post_id_foreign');
		});
		Schema::table('snippets', function(Blueprint $table) {
			$table->dropForeign('snippets_description_id_foreign');
		});
		Schema::table('faq', function(Blueprint $table) {
			$table->dropForeign('faq_description_id_foreign');
		});
		Schema::table('partners', function(Blueprint $table) {
			$table->dropForeign('partners_description_id_foreign');
		});
		Schema::table('inqueries', function(Blueprint $table) {
			$table->dropForeign('inqueries_tour_id_foreign');
		});
	}
}