<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoicesTable extends Migration {

	public function up()
	{
		Schema::create('invoices', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('user_id')->unsigned();
			$table->enum('status', array('pending', 'awaiting_approval', 'awaiting_payment', 'processing', 'delivered', 'rejected'));
			$table->float('additional_discount', 22,2)->default('0');
			$table->float('additional_price', 22,2)->default('0');
			$table->float('tax', 22,2)->default('0');
		});
	}

	public function down()
	{
		Schema::drop('invoices');
	}
}