<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Post extends Eloquent {

	protected $table = 'posts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function categories()
	{
		return $this->belongsTo('App\Models\Category', 'category_id');
	}

	public function clients()
	{
		return $this->belongsToMany('App\Models\Client', 'post_client');
	}

}