<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderTable extends Migration {

	public function up()
	{
		Schema::create('order', function(Blueprint $table) {
			$table->increments('id');
			$table->string('invoice_no', 15);
			$table->integer('customer_id')->unsigned();
			$table->string('payment_status', 25);
			$table->decimal('final_amount');
			$table->decimal('total_discount');
			$table->datetime('transaction_date');
			$table->string('order_status', 25);
			$table->text('alternative_address');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('order');
	}
}