<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductTable extends Migration {

	public function up()
	{
		Schema::create('product', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('subcategories_id')->unsigned();
			$table->integer('category_id')->unsigned();
			$table->string('product_name', 255);
			$table->decimal('price');
			$table->decimal('selling_price');
			$table->string('unit_of_measurement', 255);
			$table->text('product_details');
			$table->integer('quantity');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('product');
	}
}