<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('sub_category_id')->references('id')->on('categories')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('product_tag', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('product_tag', function(Blueprint $table) {
			$table->foreign('tag_id')->references('id')->on('tags')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('carts', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('carts', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('country_code_id')->references('id')->on('country_codes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('discount_product', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('discount_product', function(Blueprint $table) {
			$table->foreign('discount_id')->references('id')->on('discounts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('order_product', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('order_product', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('product_variants', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('product_variants', function(Blueprint $table) {
			$table->foreign('color_id')->references('id')->on('colors')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('product_prices', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('social_accounts', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('notification_setting_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('notification_setting_user', function(Blueprint $table) {
			$table->foreign('notification_setting_id')->references('id')->on('notification_settings')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('states', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('shipping_addresses', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('shipping_addresses', function(Blueprint $table) {
			$table->foreign('state_id')->references('id')->on('states')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_category_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_sub_category_id_foreign');
		});
		Schema::table('product_tag', function(Blueprint $table) {
			$table->dropForeign('product_tag_product_id_foreign');
		});
		Schema::table('product_tag', function(Blueprint $table) {
			$table->dropForeign('product_tag_tag_id_foreign');
		});
		Schema::table('categories', function(Blueprint $table) {
			$table->dropForeign('categories_parent_id_foreign');
		});
		Schema::table('carts', function(Blueprint $table) {
			$table->dropForeign('carts_user_id_foreign');
		});
		Schema::table('carts', function(Blueprint $table) {
			$table->dropForeign('carts_product_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_country_code_id_foreign');
		});
		Schema::table('discount_product', function(Blueprint $table) {
			$table->dropForeign('discount_product_product_id_foreign');
		});
		Schema::table('discount_product', function(Blueprint $table) {
			$table->dropForeign('discount_product_discount_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_user_id_foreign');
		});
		Schema::table('order_product', function(Blueprint $table) {
			$table->dropForeign('order_product_order_id_foreign');
		});
		Schema::table('order_product', function(Blueprint $table) {
			$table->dropForeign('order_product_product_id_foreign');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->dropForeign('reviews_user_id_foreign');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->dropForeign('reviews_product_id_foreign');
		});
		Schema::table('product_variants', function(Blueprint $table) {
			$table->dropForeign('product_variants_product_id_foreign');
		});
		Schema::table('product_variants', function(Blueprint $table) {
			$table->dropForeign('product_variants_color_id_foreign');
		});
		Schema::table('product_prices', function(Blueprint $table) {
			$table->dropForeign('product_prices_product_id_foreign');
		});
		Schema::table('social_accounts', function(Blueprint $table) {
			$table->dropForeign('social_accounts_user_id_foreign');
		});
		Schema::table('notification_setting_user', function(Blueprint $table) {
			$table->dropForeign('notification_setting_user_user_id_foreign');
		});
		Schema::table('notification_setting_user', function(Blueprint $table) {
			$table->dropForeign('notification_setting_user_notification_setting_id_foreign');
		});
		Schema::table('states', function(Blueprint $table) {
			$table->dropForeign('states_country_id_foreign');
		});
		Schema::table('shipping_addresses', function(Blueprint $table) {
			$table->dropForeign('shipping_addresses_user_id_foreign');
		});
		Schema::table('shipping_addresses', function(Blueprint $table) {
			$table->dropForeign('shipping_addresses_state_id_foreign');
		});
	}
}