<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->longText('description');
			$table->bigInteger('category_id')->unsigned();
			$table->bigInteger('sub_category_id')->unsigned()->nullable();
			$table->boolean('free_shipping')->default(false);
			$table->boolean('is_drafted')->default(false);
			$table->decimal('price');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}